
document.addEventListener("DOMContentLoaded", function() {
  'use strict';

  // App controls and methods
  var App = {
    mutedElements: {},
    audioContext: {
      currentIndex: false,
      maxIndex: document.querySelectorAll('#audio-tracks meta').length,
    },
    appMuted: null,
    audioControl: function(mute) {
      var mediaElements = document.querySelectorAll('video, audio');

      if (mediaElements) {
        for (var i = 0; i < mediaElements.length; i++) {
          var element = mediaElements[i];
          // If we aren't muting, and for whatever reason we didnt save the previous volume value, use full volume
          var volume = 1;
          if (this.appMuted) {
            if (this.mutedElements[element.id]) {
              volume = this.mutedElements[element.id];
            }
            this.appMuted = false;
          }
          else {
            this.mutedElements[element.id] = element.volume;
            volume = 0;
            this.appMuted = true;
          }
          element.volume = volume;
        }
        var volumeButtons = document.querySelectorAll('[data-nav="volume"] img');
        if (volumeButtons) {
          var attr = 'data-mute-src';
          if (this.appMuted) {
            attr = 'data-volume-src';
          }
          volumeButtons.forEach(function(volumeButton) {
            volumeButton.src = volumeButton.getAttribute(attr);
          });
        }
      }
    },
    // Helper to ensure that play() invocations operate properly
    playMedia: function(element, requireInteractionOnFail) {
      var playPromise = element.play();

      if (playPromise) {
        playPromise.then(function() {
          if (requireInteractionOnFail) {
            App.interactionBanner(false);
          }
        })
        .catch(function(error) {
          if (requireInteractionOnFail) {
            App.interactionBanner(true);
          }
        });
      }
    },
    interactionBanner: function(show) {
      var body = document.querySelector('body');
      if (show) {
        body.classList.add('interaction-needed');
        var bannerButton = document.querySelector('#interaction-button');
        bannerButton.addEventListener('click', function interactListen() {
          App.interactionBanner(false);
          window.location.reload();
        });
      }
      else {
        body.classList.remove('interaction-needed');
      }
    },
    buttonToggle: function(button) {
      button.classList.toggle('active');
    },
    resetAudioIndex: function() {
      this.audioContext = {
        currentIndex: false,
      };
      var player = document.querySelector("#audioElement");
      player.setAttribute('src', '');
      this.instructionalAudio(0, true);
    },
    instructionalAudio(index, playthrough) {
      if (!document.querySelector("#audio-tracks")) {
        return;
      }
      if (index == null) {
        if (!this.audioContext.currentIndex) {
          index = 0;
        }
        else {
          index = this.audioContext.currentIndex;
        }
      }
      if (playthrough == null) {
        playthrough = true;
      }
      var tracks = document.querySelector('#audio-tracks');
      var trackData = tracks.querySelectorAll('[data-audio-src]');
      var player = document.querySelector("#audioElement");
      if (!trackData[index]) {
        playthrough = false;
        this.audioContext.currentIndex = true;
      }
      else if (trackData[index].getAttribute('data-audio-src')) {
        player.setAttribute('src', trackData[index].getAttribute('data-audio-src'));
        var focusedElement = document.querySelector('[data-audio-index="' + index + '"]');
        if (focusedElement) {
          player.addEventListener('play', function buttonStart() {
            player.removeEventListener('play', buttonStart);
            var over = new Event('mouseover');
            focusedElement.dispatchEvent(over);
            //focusedElement.scrollIntoView({behavior: "smooth", block: "end", inline: "nearest"});
            var yOffset = -120;
            const y = focusedElement.getBoundingClientRect().top + window.pageYOffset + yOffset;
            window.scrollTo({top: y, behavior: 'smooth'});
          });
          player.addEventListener('ended', function buttonEnd() {
            player.removeEventListener('ended', buttonEnd);
            var out = new Event('mouseout');
            focusedElement.dispatchEvent(out);
          });
        }
        this.playMedia(player, true);
      }
      if (playthrough && this.audioContext.currentIndex !== true) {
        player.addEventListener('ended', function playNext() {
          player.removeEventListener('ended', playNext);
          App.audioContext.currentIndex = index + 1;
          App.instructionalAudio(index + 1, true);
        });
      }
      // If all audio finished
      var index1 = this.audioContext.currentIndex + 1;
      if (index1 == this.audioContext.maxIndex) {
        var tracks = document.querySelector('#audio-tracks');
        if (tracks.getAttribute('data-autonext') && tracks.getAttribute('data-next-path')) {
          player.addEventListener('ended', function() {
            window.location = tracks.getAttribute('data-next-path') + '.html';
          });
        }
      }
    },
  };

  // Autoplay video
  var video = document.querySelector("#videoElement");
  if (video) {
    App.playMedia(video);
  }

  // Autoplay instructional audio
  App.instructionalAudio();

  // If volume button is clicked, toggle the audio on the page
  var vol = document.querySelectorAll('[data-nav="volume"]');
  if (vol.length) {
    // On iphones, hide the mute button
    var hideVol = false;
    if (window.navigator.userAgent.match(/iPhone|iPad/i)) {
      hideVol = true;
    }
    for (var i = 0; i < vol.length; i++) {
      var volElement = vol[i];
      if (hideVol) {
        volElement.classList.add('hidden');
      }
      else {
        volElement.addEventListener('click', function(event) {
          event.preventDefault();
          App.audioControl();
        });
      }
    };
  }

  // Go back 1 page if the nav is clicked
  var backnav = document.querySelectorAll('[data-nav="back-nav"]');
  if (backnav.length) {
    for (var i = 0; i < backnav.length; i++) {
      var backNavElement = backnav[i];
      backNavElement.addEventListener('click', function(event) {
        event.preventDefault();
        history.back();
      });
    }
  }

  // If volume button is clicked, toggle the audio on the page
  var replaynav = document.querySelectorAll('[data-nav="audio-replay"]');
  if (replaynav.length) {
    for (var i = 0; i < replaynav.length; i++) {
      var replayNavElement = replaynav[i];
      replayNavElement.addEventListener('click', function(event) {
        event.preventDefault();
        App.resetAudioIndex();
      });
    }
  }

  // Give the document access to our code
  window.App = App;

});
